using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Data.SqlClient;
using System.Runtime.Serialization;


namespace StrataFlix.Business
{
	[Serializable()]public partial class PeopleImagesBO : StrataFlixBaseBO
	{
		
		
		#region " Constructors "
		
		/// <summary>
		/// Initializes a new instance of the PeopleImagesBO class.
		/// </summary>
		/// <remarks></remarks>
		[System.Diagnostics.DebuggerNonUserCodeAttribute()]public PeopleImagesBO()
		{
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Initializes a new instance of the PeopleImagesBO class.
		/// </summary>
		/// <param name="Container">The IContainer to which this object will be added.</param>
		/// <remarks></remarks>
		[System.Diagnostics.DebuggerNonUserCodeAttribute()]public PeopleImagesBO(System.ComponentModel.IContainer Container)
		{
			//This call adds the component to the given container.
			Container.Add(this);
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Initializes a new instance of the PeopleImagesBO class.
		/// </summary>
		/// <param name="info">The SerializationInfo for the object.</param>
		/// <param name="context">The StreamingContext for the source stream.</param>
		/// <remarks></remarks>
		protected PeopleImagesBO(SerializationInfo info, StreamingContext context) : base(info, context)
		{
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Adds the necessary handlers for the PeopleImagesBO class.
		/// </summary>
		/// <remarks></remarks>
		private void AddHandlers()
		{
			this.CheckRulesOnCurrentRow += new MicroFour.StrataFrame.Business.BusinessLayer.CheckRulesOnCurrentRowEventHandler(PeopleImagesBO_CheckRulesOnCurrentRow);
			this.SetDefaultValues += new MicroFour.StrataFrame.Business.BusinessLayer.SetDefaultValuesEventHandler(PeopleImagesBO_SetDefaultValues);
		}
		
		#endregion
		
		#region " Event Handlers "
		
		/// <summary>
		/// Checks the business rules on the current row
		/// </summary>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private void PeopleImagesBO_CheckRulesOnCurrentRow(MicroFour.StrataFrame.Business.CheckRulesEventArgs e)
		{
			
		}
		
		/// <summary>
		/// Sets the default values for a new row
		/// </summary>
		/// <remarks></remarks>
		private void PeopleImagesBO_SetDefaultValues()
		{
			pli_CreatedAt = DateTime.Now;
			pli_CreatedBy = MicroFour.StrataFrame.Security.SecurityBasics.CurrentUser.UserPK;
		}
		
		#endregion
		
		#region " Protected Methods "
		
		/// <summary>
		/// Provide type descriptors for the custom properties
		/// </summary>
		/// <returns></returns>
		/// <remarks></remarks>
		protected override MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] GetCustomBindablePropertyDescriptors()
		{
			return new MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] {new ReflectionPropertyDescriptor("pli_PhotoLarge", typeof(PeopleImagesBO))};
		}
		
		#endregion
		
		#region " Public Methods "
		
		/// <summary>
		/// Determines if a photo is attached
		/// </summary>
		/// <returns></returns>
		/// <remarks></remarks>
		public bool HasPhoto()
		{
			return this.Count > 0 && !(this.CurrentRow["pli_ImageData"] is DBNull) && pli_ImageData.Length > 0;
		}
		
		#endregion
		
		#region " Public Properties "
		
		/// <summary>
		/// The photo in a large media format
		/// </summary>
		/// <value></value>
		/// <returns></returns>
		/// <remarks></remarks>
		[Browsable(false), BusinessFieldDisplayInEditor(), Description("Photo - Large"), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]public Image pli_PhotoLarge
		{
			get
			{
				//-- Establish Locals
				Image r;
				MemoryStream memStream;
				
				if (this.Count == 0 || pli_ImageData.Length == 0)
				{
                    r = StrataFlix.Business.Properties.Resources.DefaultMovieImage;
				}
				else
				{
					//-- Convert the byte array into a bitmap by placing in a memory stream
					//   and then creating a bitmap from the stream
					memStream = new MemoryStream();
					memStream.Write(pli_ImageData, 0, pli_ImageData.Length);
					r = new Bitmap(memStream);
					memStream.Dispose();
				}
				
				//-- Return the results
				return r;
			}
			set
			{
				//-- Establish Locals
				MemoryStream memStream = new MemoryStream();
				
				//-- Save the image to a memory stream as a PNG format
				value.Save(memStream, System.Drawing.Imaging.ImageFormat.Png);
				
				//-- Save the memory stream as a byte array back to the VarBinary field
				pli_ImageData = memStream.ToArray();
			}
		}
		
		#endregion
		
	}
	
}
